#include "stdafx.h"
#include "8949G1VC.h"
#include "CtrlCardSingletion.h"
#include "DialogBasicMoveDlg.h"
#include "ADT8949.h"
#include "DialogBasicMoveDlg.h"
extern BOOL m_Bdec ;


//CCtrlCardSingletion g_CCtrcard;
//////////////////////////////////////////////////////////////////////
//
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CCtrlCardSingletion::CCtrlCardSingletion()
{

}

CCtrlCardSingletion::~CCtrlCardSingletion()
{
//ReleaseCtrlCardSingletion();
}

CCtrlCardSingletion* CCtrlCardSingletion::m_pInstance = NULL;

//////////////////////////////////////////////////////////////////////////
//
// [12/11/2012 Administrator]:The most important function
CCtrlCardSingletion* CCtrlCardSingletion::Instance()
{
	if (NULL == m_pInstance)
	{
		m_pInstance = new CCtrlCardSingletion();
	}
	return m_pInstance;
}

//////////////////////////////////////////////////////////////////////////
//
// [12/11/2012 Administrator]:Free memory space
void CCtrlCardSingletion::ReleaseCtrlCardSingletion()
{
	if (m_pInstance != NULL)
	{
		delete m_pInstance;
	}
	return;
}

//////////////////////////////////////////////////////////////////////////
//
//this function is boot of using motion-card
//    Return<=0 fail to initial motion-card
//	Return>0  Succeed in initial motion-card
// [12/11/2012 Administrator]:initial function
int CCtrlCardSingletion::InitBoard()
{
	 int Result  = -1;
	Result = adt8949_initial();        //intiial motion-card    
	
	if (Result <= 0) return Result;

    for (int i = 1; i<=MAXAXIS; i++)
	{  	 
       adt8949_set_command_pos (g_cardID, i, 0);        //Clean logic counter
       
       adt8949_set_actual_pos (g_cardID, i, 0);         //Clean real counter
       
       adt8949_set_startv (g_cardID, i, 0);             //set start speed
       
       adt8949_set_speed (g_cardID, i, 50);             //set motion speed

	   adt8949_set_acc(g_cardID, i, 500);               //set acceleration
	   
    }
	adt8949_set_startv (g_cardID, INPA_AXISREG, 0);          //set start speed
	adt8949_set_speed (g_cardID, INPA_AXISREG, 20);          //set motion speed
	adt8949_set_acc(g_cardID, INPA_AXISREG, 500);            //set acceleration
	

	Result = 1;
	return Result;
}

//////////////////////////////////////////////////////////////////////////
//
// [12/11/2012 Administrator]:Get hardware version and DLL version
void CCtrlCardSingletion::GetVersion(int &fLibVer, int &fHardwareVer)
{

 	fLibVer = adt8949_get_lib_version();
 	fHardwareVer = adt8949_get_firmware_ver(g_cardID);
	return;
}

//////////////////////////////////////////////////////////////////////////
//FunctionGet the driving status of each axis
//Parameter
// nCardno      Card number
// nAxis        Axis number (1-4)
// nValue           Pointer of driving status
// 0 Driving ends                             1Driving
// Return             0correct                               -1wrong
// [12/20/2012 Administrator]:Check drive state
int CCtrlCardSingletion::GetStatus(int nCardNo, int nAxis, int *nValue)
{
	int nResult = -1;
	nResult = adt8949_get_status(nCardNo, nAxis, nValue);
	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//
// According to the values of the parameters, the speed of the shaft is the initial speed, the driving speed and the acceleration of the shaft.
// 
//Parameter	nAxis   -axis number
// `		nStartv -start speed 
//			nSpeed  -drive speed
//			nAdd    -acceleration
// 
// Return             0correct                               -1wrong
// [12/12/2012 Administrator]:
int CCtrlCardSingletion::SetupSpeed(int nAxis, float nStartv, float nSpeed, float nAdd,float nDec,unsigned short ADMode)
{
	int ia,Result;
	
	if(nAxis==INPA_AXISREG)ia=AINPA;
	else ia=nAxis-1;
	

	Result = adt8949_set_admode(g_cardID,nAxis,ADMode);
	
	//*************set speed***************//
	Result = adt8949_set_startv(g_cardID, nAxis, nStartv);	
	Result = adt8949_set_speed (g_cardID, nAxis, nSpeed);	
	Result = adt8949_set_acc (g_cardID, nAxis, nAdd);  //Note that the acceleration setting must be placed in the setting of the speed of the reduction, and can be no, not set that is symmetric acceleration and deceleration
	if(m_Bdec == TRUE)
	{
		Result = adt8949_set_dec (g_cardID, nAxis, nDec);  
	}

	return Result;
}

//////////////////////////////////////////////////////////////////////////
//
// The function is used for setting logical positions and actual positions
// 
// parameter	axis-axis number,
//			pos-the value of setting
//			mode 0set logic position,Non 0set actually position
// 
// Return             0correct                               -1wrong
// [12/12/2012 Administrator]:Set position counter
int CCtrlCardSingletion::SetupPos(int nAxis, long nPos, int nMode)
{
	int nResult = -1;
 	if(0 == nMode)
 	{
		nResult = adt8949_set_command_pos(g_cardID, nAxis, nPos);
	}
 	else
 	{
 		nResult = adt8949_set_actual_pos(g_cardID, nAxis, nPos);
 	}

	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//    
// parameter   nAxis-axis number
//			nValue-Output pulse number
// 
// Return             0correct                               -1wrong
// [12/12/2012 Administrator]:The function is used to drive single axis motion
int CCtrlCardSingletion::AxisPmove(int nAxis ,float nValue)
{
	int nResult = -1;

	nResult = adt8949_pmove(g_cardID, nAxis, nValue);

	return nResult;

}

//////////////////////////////////////////////////////////////////////////
// 
// Description: the function is used for the current logical position of the feedback axis, the actual position and the speed of the operation
//
// parameteraxis-axis number,LogPos-logic position,ActPos-actual position,Speed-running speed
// 
// Return             0correct                               -1wrong
//
// [12/12/2012 Administrator]:Get motion information
int CCtrlCardSingletion::GetCurrentInfo(int nAxis, long &nLogPos, long &nActPos, float &fSpeed)
{
	int nResult = -1;
 	nResult = adt8949_get_command_pos(g_cardID, nAxis, &nLogPos);
 	adt8949_get_actual_pos(g_cardID, nAxis, &nActPos);
 	adt8949_get_speed(g_cardID, nAxis, &fSpeed);	

	return nResult;
}

int CCtrlCardSingletion::INP_GetCurrentInfo(int nAxis, long &nLogPos, long &nActPos, float &fSpeed)
{
	int nResult = -1;
	nResult = adt8949_get_command_pos(g_cardID, nAxis, &nLogPos);
	adt8949_get_actual_pos(g_cardID, nAxis, &nActPos);
	adt8949_get_speed(g_cardID, INPA_AXISREG, &fSpeed);	
	
	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//
// The function is used for the drive of an immediate or retarding stop shaft
// 
//parameter	nAxis-axis number
//			mode-Deceleration mode(g_cardIDImmediately stop, 1Slow down)
// 
// Return             0correct                               1wrong
//
// [12/12/2012 Administrator]:Stop axis drive
int CCtrlCardSingletion::StopRun(int nAxis, int nMode)
{
	int nResult = -1;

	if (g_cardID == nMode)		// Immediately stop
	{
		nResult = adt8949_sudden_stop(g_cardID, nAxis);
	}
	if (1 == nMode)		// Slow down
	{
		nResult = adt8949_dec_stop(g_cardID, nAxis);
	}

	return nResult;
}
//////////////////////////////////////////////////////////////////////////
//
// The function is used to drive arbitrary uniaxial interpolation motion
// 
// parameternAxis1,nAxis2-axis numbernValue1,nValue2-the number of pulser
// 
// return  0 correct1 wrong
//
// [12/12/2012 Administrator]:Any two axis interpolation
int CCtrlCardSingletion::InterpMove1(int axis1,  float value1)
{
	float pos[5];
	int Result=-1;
	if (axis1<1 || axis1 >MAX_AXIS )goto Err;


	memset(pos,0x00,sizeof(float)*5);
	pos[axis1]=value1;

	Result = adt8949_inp_move4(g_cardID,0,pos[1],pos[2],pos[3],pos[4]);	
	if(Result)goto Err;

	return 0;
	Err:
		return Result;
}

//////////////////////////////////////////////////////////////////////////
//
// The function is used to drive arbitrary uniaxial interpolation motion
// 
// parameternAxis1,nAxis2-axis numbernValue1,nValue2-the number of pulser
// 
// return  0 correct1 wrong
//
// [12/12/2012 Administrator]:Any two axis interpolation
int CCtrlCardSingletion::InterpMove2(int axis1, int axis2, float value1, float value2)
{
	float pos[5];
	int Result=-1;
	if (axis1<1 || axis1 >MAX_AXIS )goto Err;
	if (axis2<1 || axis2 >MAX_AXIS )goto Err;
	
	memset(pos,0x00,sizeof(float)*5);
	pos[axis1]=value1;
	pos[axis2]=value2;
	
	Result = adt8949_inp_move4(g_cardID,0,pos[1],pos[2],pos[3],pos[4]);	
	if(Result)goto Err;
	
	return 0;
Err:
	return Result;
}

//////////////////////////////////////////////////////////////////////////
//
// The function is used to drive arbitrary uniaxial interpolation motion
//     
// parameteraxis1,axis2,axis3-axis numbervalue1,value2,value3-the number of pulser
//     
// return  0 correct1 wrong
//
// [12/12/2012 Administrator]:Any three axis interpolation
int CCtrlCardSingletion::InterpMove3(int axis1, int axis2, int axis3, float value1, float value2, float value3)
{
	float pos[5];	
	int Result=-1;
	if (axis1<1 || axis1 >MAX_AXIS )goto Err;
	if (axis2<1 || axis2 >MAX_AXIS )goto Err;
	if (axis3<1 || axis3 >MAX_AXIS )goto Err;
	
	
	
	memset(pos,0x00,sizeof(float)*5);
	pos[axis1]=value1;
	pos[axis2]=value2;
	pos[axis3]=value3;
	
	Result = adt8949_inp_move4(g_cardID,0,pos[1],pos[2],pos[3],pos[4]);	
	if(Result)goto Err;
	
	return 0;
Err:
	return Result;
	
}

//////////////////////////////////////////////////////////////////////////
//
// The function is used to drive arbitrary uniaxial interpolation motion
//     
// parametervalue1,value2,value3,value4-the number of pulser
//     
// return  0 correct1 wrong
//
// [12/12/2012 Administrator]:all axis interpolation
int CCtrlCardSingletion::InterpMove4(float value1, float value2, float value3, float value4)
{
	int Result=-1;
	Result = adt8949_inp_move4(g_cardID,0, value1, value2, value3, value4);
	if(Result)goto Err;
	
	return 0;
Err:
	return Result;
	
}

//////////////////////////////////////////////////////////////////////////
//
// [12/13/2012 Administrator]:read input
int CCtrlCardSingletion::ReadInput(int nNumber)
{
	int nResult = -1;
	nResult = adt8949_read_bit(g_cardID, nNumber);

	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//
// [12/13/2012 Administrator]:write output
int CCtrlCardSingletion::WriteOutput(int nNumber, int nValue)
{
	int nResult = -1;
	nResult = adt8949_write_bit(g_cardID, nNumber, nValue);/**/

	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//
//The function is used to set the working mode of a pulse
// 
// parameteraxis-axis number value-pulse mode 0pulser and pulser 1pulser and direction
// 
// return  0 correct1 wrong
// 
// Default pulse mode is pulser and direction
// 
// The program uses the default positive logic pulse and the direction of the output signal is logic
//
// [12/13/2012 Administrator]:Set pulse output mode
int CCtrlCardSingletion::SetupPulseMode(int nAxis, int nValue)
{
	int nResult = -1;
	nResult = adt8949_set_pulse_mode(g_cardID, nAxis, nValue, 0, 0);


	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//FunctionSet the mode of positive/negative limit input signal nLMT
//Para
//nAxis           axis number(1-4)
//nValue1          0positive limit valid                      1positive limit invalid
//nValue2          0negative limit valid                      1negative limit invalid
//nLogic       0low level valid                      1high level valid
//Return                 0success                                 1failure
//default modespositive limit valid negative limit valid low level valid
// [12/13/2012 Administrator]:set limit signal mode
int CCtrlCardSingletion::SetupLimitMode(int nAxis, int nValue1, int nValue2, int nLogic)
{
	int nResult = -1;
	
	nResult = adt8949_set_limit_mode(g_cardID, nAxis, nValue1, nValue2, nLogic);/**/

	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//
//Parameter
//       nAxis        Axis number (1-4)
//       nValue           0Inactive                 1Active
//       nLogic       0Low level active         1High level active
//       admode      0Deceleration stop        1Immediate stop
//Return             0correct                  -1wrong
//Default modes stop0 inactive
//
// [12/13/2012 Administrator]:Set stop0 signal mode
int CCtrlCardSingletion::SetupStop0Mode(int nAxis, int nValue, int nLogic,int admode)
{
	int nResult = -1;

	
 	nResult = adt8949_set_stop0_mode(g_cardID, nAxis, nValue, nLogic,admode);



	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//
//FunctionSet positive/negative limit mode
//Parameter
//       cardno      Card number
//       axis        Axis number (1-4)
//       v           0 Inactive                        1Active
//       logic       0Low level active                 1High level active
//       admode          0Deceleration stop            1Immediate stop
//Return                 0correct                      -1wrong
//Default modes Inactive
//Remarksstop1 is servo origin or Z-phase signal, IN44, IN45, IN46, IN47 
//
// [12/13/2012 Administrator]:
int CCtrlCardSingletion::SetupStop1Mode(int nAxis, int nValue, int nLogic,int admode)
{
	int nResult = -1;
 	nResult = adt8949_set_stop1_mode(g_cardID, nAxis, nValue, nLogic,admode);

	return nResult;
}

//////////////////////////////////////////////////////////////////////////
//
// [12/13/2012 Administrator]:
int CCtrlCardSingletion::SetupHardStop(int nValue, int nLogic)
{
	int nResult = -1;


	if (nValue)
	{	
		nResult = adt8949_set_emergency_stop_mode(g_cardID,16,nLogic);
	} 
	else
	{	

		nResult = adt8949_set_emergency_stop_mode(g_cardID,255,nLogic);
	}	

	return nResult;
}


//////////////////////////////////////////////////////////////////////////
//
//FunctionGet output IO status (adt8949_et_out)
//Parameter
//       cardno      Card number
//       number        Output point (0-31), which is suitable for rapid output points, 0 to 14 15 to 31 points for bus output
//Return                Return value: the current state of the specified port, 1 said parameter error
//Remarks
int CCtrlCardSingletion::GetOutNum(int nNumber)
{
	int nResult = -1;
 	nResult = adt8949_get_out(g_cardID, nNumber);

	return nResult;
}

int CCtrlCardSingletion::SetAccDecAndSpeed(int axis,float add,float dec,float startv, float speed, float endv)
{	
	int Result=-1;
	if (startv > speed ) //Uniform motion
	{    
		Result = adt8949_set_startv(g_cardID, axis, speed);		
		if(Result)goto Err;
	}else
	{
		Result = adt8949_set_startv(g_cardID, axis, startv);		
		if(Result)goto Err;
	}	
	
	Result = adt8949_set_acc (g_cardID, axis, add); 
	if(Result)goto Err;
	
	Result = adt8949_set_dec (g_cardID, axis, dec); 
	if(Result)goto Err;
	
	Result = adt8949_set_speed (g_cardID, axis, speed);
	if(Result)goto Err;
	
	Result = adt8949_set_endv (g_cardID, axis, endv);
	if(Result)goto Err;	
	
	return 0;
Err:
	return Result;
}
